#include <stdio.h> 

#define BOOL            int
#define TRUE            1
#define FALSE           0

ENV

/* message types */
#define CNTL            0
#define DATA            1
#define END_SIGNAL      2

BEGIN_MSG_TYPES
    MSG_TYPE(CNTL,
        struct cntl_rec {
                PROC_ID prev;
		PROC_ID next;
        };
    )

    MSG_TYPE(DATA,
        struct data_rec {
                int ln;
                char buf[1000];
        };
    )

    MSG_TYPE(END_SIGNAL,EMPTY)
END_MSG_TYPES
PROC_ID process_ids[4], id;

main()
{

    struct cntl_rec rec1;
    struct data_rec rec2, echo_data;

    long i, j, msg_type, bytes;
    char c;

    BOOL mismatch;

	printf("DEBUG -- before initenv \n");

    INITENV 

	printf("DEBUG -- after initenv \n");

    WHO_AM_I(&(process_ids[0]))

	printf("DEBUG -- after whoami \n");

    REMOTE_CREATE(ring_of_procs)

	printf("DEBUG -- after remote create \n");

    /*
       Send off id's of successors to slave processes.
       Each process gets the ids of the previous and next
       processes; we set the next of slave 3 to be the master.
       To understand the next loop, note that process_ids contains:

		[0] - process id of master
		[1] - process id of slave 1
		[2] - process id of slave 2
		[3] - process id of slave 3
    */
    for (i = 1; (i < 4); i++) {
        COPY_ID(&rec1.prev, &process_ids[i-1])
	j = (i + 1) % 4;
        COPY_ID(&rec1.next, &process_ids[j])
		printf("DEBUG -- sending to %d i = %d\n",process_ids[i],i);
        SENDR(&process_ids[i], CNTL, &rec1)
    }

    /*
       Pipe stdin through the slave processes
    */
    while ((c = getchar()) != EOF) {
        for (i = 0;  (i < 1000) && (c != '\n');  i++) {
            rec2.buf[i] = c;
            c = getchar();
        }
        rec2.ln = i;

        bytes = sizeof(rec2) - ((1000 - i) * sizeof(char));

        rec2.buf[i] = '\0';
        SENDR(&process_ids[1], DATA, &rec2, bytes)
        RECEIVE(&id, &msg_type, &echo_data, 
		(match_id(&(process_ids[3])) && match_type(DATA))) 
        if (rec2.ln != echo_data.ln)
            mismatch = TRUE;
        else {
            for (mismatch = FALSE, i = 0; 
                 (i < rec2.ln) && (!mismatch);
                 i++) {

                if (rec2.buf[i] != echo_data.buf[i])
                    mismatch = TRUE;
            }
        }

        if (mismatch) {
            printf("*** data mismatch: send/receive failure\n");

            printf("sent:");
            for (i = 0; (i < rec2.ln); i++)
                putchar(rec2.buf[i]);

            printf("\nrcvd:");
            for (i = 0; (i < echo_data.ln); i++)
                putchar(echo_data.buf[i]);
            putchar('\n');
            exit(3);
        }
    }
    SENDR(&process_ids[1], END_SIGNAL)
    RECEIVE(&id, &msg_type, , 
	    (match_id(&process_ids[3]) && match_type(END_SIGNAL)))
    printf("successful completion\n");
    WAIT_FOR_END(3)
}
